﻿using System;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using sp.SQLServerDAL;
namespace sp.DAL
{
    /// <summary>
    /// 数据访问类sp_book。
    /// </summary>
    public class sp_book
    {
        public sp_book()
        { }
        #region  成员方法
        /// <summary>
        /// 是否存在该记录
        /// </summary>
        public bool Exists(int ID)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select count(1) from sp_book");
            strSql.Append(" where ID= @ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)
				};
            parameters[0].Value = ID;
            return DbHelperSQL.Exists(strSql.ToString(), parameters);
        }


        /// <summary>
        /// 增加一条数据
        /// </summary>
        public void Add(sp.Model.sp_book model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("insert into sp_book(");
            strSql.Append("Sp_NAME,Sp_Email,Sp_HomePage,Sp_qq,Sp_msn,Sp_UserFrom,Sp_CONTENT,Sp_REPLY,Sp_REPLY_EMAIL,Sp_ADDTIME,Sp_RETIME,Sp_IP)");
            strSql.Append(" values (");
            strSql.Append("@Sp_NAME,@Sp_Email,@Sp_HomePage,@Sp_qq,@Sp_msn,@Sp_UserFrom,@Sp_CONTENT,@Sp_REPLY,@Sp_REPLY_EMAIL,@Sp_ADDTIME,@Sp_RETIME,@Sp_IP)");
            SqlParameter[] parameters = {
					new SqlParameter("@Sp_NAME", SqlDbType.NVarChar),
					new SqlParameter("@Sp_Email", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_HomePage", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_qq", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_msn", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_UserFrom", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_CONTENT", SqlDbType.NText),
					new SqlParameter("@Sp_REPLY", SqlDbType.NText),
					new SqlParameter("@Sp_REPLY_EMAIL", SqlDbType.Bit,1),
					new SqlParameter("@Sp_ADDTIME", SqlDbType.SmallDateTime),
					new SqlParameter("@Sp_RETIME", SqlDbType.SmallDateTime),
					new SqlParameter("@Sp_IP", SqlDbType.NVarChar)};
            parameters[0].Value = model.Sp_NAME;
            parameters[1].Value = model.Sp_Email;
            parameters[2].Value = model.Sp_HomePage;
            parameters[3].Value = model.Sp_qq;
            parameters[4].Value = model.Sp_msn;
            parameters[5].Value = model.Sp_UserFrom;
            parameters[6].Value = model.Sp_CONTENT;
            parameters[7].Value = model.Sp_REPLY;
            parameters[8].Value = model.Sp_REPLY_EMAIL;
            parameters[9].Value = model.Sp_ADDTIME;
            parameters[10].Value = model.Sp_RETIME;
            parameters[11].Value = model.Sp_IP;

            DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
        }
        /// <summary>
        /// 更新一条数据
        /// </summary>
        public void Update(sp.Model.sp_book model)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("update sp_book set ");
            strSql.Append("Sp_NAME=@Sp_NAME,");
            strSql.Append("Sp_Email=@Sp_Email,");
            strSql.Append("Sp_HomePage=@Sp_HomePage,");
            strSql.Append("Sp_qq=@Sp_qq,");
            strSql.Append("Sp_msn=@Sp_msn,");
            strSql.Append("Sp_UserFrom=@Sp_UserFrom,");
            strSql.Append("Sp_CONTENT=@Sp_CONTENT,");
            strSql.Append("Sp_REPLY=@Sp_REPLY,");
            strSql.Append("Sp_REPLY_EMAIL=@Sp_REPLY_EMAIL,");
            strSql.Append("Sp_ADDTIME=@Sp_ADDTIME,");
            strSql.Append("Sp_RETIME=@Sp_RETIME,");
            strSql.Append("Sp_IP=@Sp_IP");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4),
					new SqlParameter("@Sp_NAME", SqlDbType.NVarChar),
					new SqlParameter("@Sp_Email", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_HomePage", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_qq", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_msn", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_UserFrom", SqlDbType.VarChar,50),
					new SqlParameter("@Sp_CONTENT", SqlDbType.NText),
					new SqlParameter("@Sp_REPLY", SqlDbType.NText),
					new SqlParameter("@Sp_REPLY_EMAIL", SqlDbType.Bit,1),
					new SqlParameter("@Sp_ADDTIME", SqlDbType.SmallDateTime),
					new SqlParameter("@Sp_RETIME", SqlDbType.SmallDateTime),
					new SqlParameter("@Sp_IP", SqlDbType.NVarChar)};
            parameters[0].Value = model.ID;
            parameters[1].Value = model.Sp_NAME;
            parameters[2].Value = model.Sp_Email;
            parameters[3].Value = model.Sp_HomePage;
            parameters[4].Value = model.Sp_qq;
            parameters[5].Value = model.Sp_msn;
            parameters[6].Value = model.Sp_UserFrom;
            parameters[7].Value = model.Sp_CONTENT;
            parameters[8].Value = model.Sp_REPLY;
            parameters[9].Value = model.Sp_REPLY_EMAIL;
            parameters[10].Value = model.Sp_ADDTIME;
            parameters[11].Value = model.Sp_RETIME;
            parameters[12].Value = model.Sp_IP;

            DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
        }

        /// <summary>
        /// 删除一条数据
        /// </summary>
        public void Delete(int ID)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("delete sp_book ");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)
				};
            parameters[0].Value = ID;
            DbHelperSQL.ExecuteSql(strSql.ToString(), parameters);
        }


        /// <summary>
        /// 得到一个对象实体
        /// </summary>
        public sp.Model.sp_book GetModel(int ID)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select * from sp_book ");
            strSql.Append(" where ID=@ID");
            SqlParameter[] parameters = {
					new SqlParameter("@ID", SqlDbType.Int,4)};
            parameters[0].Value = ID;
            sp.Model.sp_book model = new sp.Model.sp_book();
            DataSet ds = DbHelperSQL.Query(strSql.ToString(), parameters);
            model.ID = ID;
            if (ds.Tables[0].Rows.Count > 0)
            {
                model.Sp_NAME = ds.Tables[0].Rows[0]["Sp_NAME"].ToString();
                model.Sp_Email = ds.Tables[0].Rows[0]["Sp_Email"].ToString();
                model.Sp_HomePage = ds.Tables[0].Rows[0]["Sp_HomePage"].ToString();
                model.Sp_qq = ds.Tables[0].Rows[0]["Sp_qq"].ToString();
                model.Sp_msn = ds.Tables[0].Rows[0]["Sp_msn"].ToString();
                model.Sp_UserFrom = ds.Tables[0].Rows[0]["Sp_UserFrom"].ToString();
                model.Sp_CONTENT = ds.Tables[0].Rows[0]["Sp_CONTENT"].ToString();
                model.Sp_REPLY = ds.Tables[0].Rows[0]["Sp_REPLY"].ToString();
                if (ds.Tables[0].Rows[0]["Sp_REPLY_EMAIL"].ToString() != "")
                {
                    if ((ds.Tables[0].Rows[0]["Sp_REPLY_EMAIL"].ToString() == "1") || (ds.Tables[0].Rows[0]["Sp_REPLY_EMAIL"].ToString().ToLower() == "true"))
                    {
                        model.Sp_REPLY_EMAIL = true;
                    }
                    else
                    {
                        model.Sp_REPLY_EMAIL = false;
                    }
                }

                if (ds.Tables[0].Rows[0]["Sp_ADDTIME"].ToString() != "")
                {
                    model.Sp_ADDTIME = DateTime.Parse(ds.Tables[0].Rows[0]["Sp_ADDTIME"].ToString());
                }
                if (ds.Tables[0].Rows[0]["Sp_RETIME"].ToString() != "")
                {
                    model.Sp_RETIME = DateTime.Parse(ds.Tables[0].Rows[0]["Sp_RETIME"].ToString());
                }
                model.Sp_IP = ds.Tables[0].Rows[0]["Sp_IP"].ToString();
                return model;
            }
            else
            {
                return null;
            }
        }
        /// <summary>
        /// 获得数据列表
        /// </summary>
        public DataSet GetList(string strWhere)
        {
            StringBuilder strSql = new StringBuilder();
            strSql.Append("select [ID],[Sp_NAME],[Sp_Email],[Sp_HomePage],[Sp_qq],[Sp_msn],[Sp_UserFrom],[Sp_CONTENT],[Sp_REPLY],[Sp_REPLY_EMAIL],[Sp_ADDTIME],[Sp_RETIME],[Sp_IP] ");
            strSql.Append(" FROM sp_book ");
            if (strWhere.Trim() != "")
            {
                strSql.Append(" where " + strWhere);
            }
            strSql.Append(" order by id desc");
            return DbHelperSQL.Query(strSql.ToString());
        }

        /*
        /// <summary>
        /// 分页获取数据列表
        /// </summary>
        public DataSet GetList(int PageSize,int PageIndex,string strWhere)
        {
            SqlParameter[] parameters = {
                    new SqlParameter("@tblName", SqlDbType.VarChar, 255),
                    new SqlParameter("@fldName", SqlDbType.VarChar, 255),
                    new SqlParameter("@PageSize", SqlDbType.Int),
                    new SqlParameter("@PageIndex", SqlDbType.Int),
                    new SqlParameter("@IsReCount", SqlDbType.Bit),
                    new SqlParameter("@OrderType", SqlDbType.Bit),
                    new SqlParameter("@strWhere", SqlDbType.VarChar,1000),
                    };
            parameters[0].Value = "sp_book";
            parameters[1].Value = "ID";
            parameters[2].Value = PageSize;
            parameters[3].Value = PageIndex;
            parameters[4].Value = 0;
            parameters[5].Value = 0;
            parameters[6].Value = strWhere;	
            return DbHelperSQL.RunProcedure("UP_GetRecordByPage",parameters,"ds");
        }*/

        #endregion  成员方法
    }
}

